/************************************************************************
* COPYRIGHT:   Copyright    1998 Symbol Technologies, Inc. 
*
* FILE:        ScanMgr.h
*
* SYSTEM:      Symbol barcode scanner for Palm III.
*
* HEADER:      Scan Manager Library Header
*
* DESCRIPTION: Provides function declarations and other types for
*					use by a scanner-aware application.
*
* HISTORY:     4/13/98    SS   Created
*			  11/27/00	  CFS  updated type names for PalmOS 3.5
*              ...
*************************************************************************/
#pragma once
#ifdef __cplusplus
   extern "C" {
#endif
#include "ScanMgrDef.h"

/*******************************************************************
 * 			  Function to check if we're on a PalmSymbol device
 *******************************************************************/
Int16 ScanIsPalmSymbolUnit();

/*******************************************************************
 *   Functions for opening and closing the decoder (required!)     *
 *******************************************************************/
Int16 ScanOpenDecoder();
Int16 ScanCloseDecoder();

/*******************************************************************
 *            Parameters send/retrieve functions                   *
 *******************************************************************/
Int16 ScanCmdSendParams( BeepType beep );
Int16 ScanCmdGetAllParams( UInt8* pbParams, UInt16 max_length );

/*******************************************************************
 *               Versioning functions                              *
 *******************************************************************/
Int16 ScanGetScanManagerVersion( Char *  pszVer, UInt16 max_length );
Int16 ScanGetScanPortDriverVersion( Char *  pszVer, UInt16 max_length );
Int16 ScanGetDecoderVersion( Char *  pszVer, UInt16 max_length);

/*******************************************************************
 *            Decoder Data Retrieval Function                      *
 *******************************************************************/
Int16 ScanGetDecodedData( MESSAGE *ptr);
Int16 ScanGetExtendedDecodedData( Int16 length, Int16 *type, UInt8 *extendedData);

/*******************************************************************
 * Functions to enable/disable scanning of various barcode types   *
 *******************************************************************/
Int16 ScanSetBarcodeEnabled( BarType barcodeType, Boolean bEnable );
Int16 ScanGetBarcodeEnabled( BarType barcodeType );

/*******************************************************************
 *   Functions for get/set the barcode lengths to be scanned       *
 *******************************************************************/
Int16 ScanSetBarcodeLengths( BarType barcodeType, UInt16 lengthType, UInt16 length1, UInt16 length2 );
Int16 ScanGetBarcodeLengths( BarType barcodeType, UInt16* pLengthType, UInt16* pLength1, UInt16* pLength2 );

/*******************************************************************
 *                 Preamble functions...                           *
 *******************************************************************/
Int16 ScanSetUpcPreamble( BarType barcodeType, Int16 preamble);
Int16 ScanGetUpcPreamble( BarType barcodeType);

/*******************************************************************
 *              Prefix/Suffix functions...                         *
 *******************************************************************/
Int16 ScanSetPrefixSuffixValues( Int8 prefix, Int8 suffix_1, Int8 suffix_2 );
Int16 ScanGetPrefixSuffixValues( Char *  pPrefix, Char *  pSuffix_1, Char *  pSuffix_2 );

Int16 ScanSetCode32Prefix( Boolean bEnable );
Int16 ScanGetCode32Prefix();

/*******************************************************************
 * Functions to get/set which barcode conversions are in effect    *
 *******************************************************************/
Int16 ScanSetConvert( ConvertType conversion, Boolean bEnable);
Int16 ScanGetConvert( ConvertType conversion);


/*******************************************************************
 *           Check Digit setup functions                           *
 *******************************************************************/
Int16 ScanSetTransmitCheckDigit( BarType barType, UInt16 check_digit );
Int16 ScanGetTransmitCheckDigit( BarType barType );

Int16 ScanSetCode39CheckDigitVerification( UInt16 check_digit );
Int16 ScanGetCode39CheckDigitVerification();

Int16 ScanSetI2of5CheckDigitVerification( UInt16 check_digit );
Int16 ScanGetI2of5CheckDigitVerification();

Int16 ScanSetMsiPlesseyCheckDigits( UInt16 check_digits );
Int16 ScanGetMsiPlesseyCheckDigits();

Int16 ScanSetMsiPlesseyCheckDigitAlgorithm( UInt16 algorithm );
Int16 ScanGetMsiPlesseyCheckDigitAlgorithm();

/*******************************************************************
 *              Supplemental/Redundancy Functions...               *
 *******************************************************************/
Int16 ScanSetDecodeUpcEanSupplementals(  UInt16 supplementals );
Int16 ScanGetDecodeUpcEanSupplementals();

Int16 ScanSetDecodeUpcEanRedundancy(  UInt16 supplemental_redundancy );
Int16 ScanGetDecodeUpcEanRedundancy();

/*******************************************************************
 *              Miscellaneous Functions...                         *
 *******************************************************************/

Int16 ScanSetCode39FullAscii( Boolean bEnable );
Int16 ScanGetCode39FullAscii();

Int16 ScanSetClsiEditing( Boolean bEnable );
Int16 ScanGetClsiEditing();

Int16 ScanSetNotisEditing( Boolean bEnable );
Int16 ScanGetNotisEditing();

Int16 ScanSetUpcEanSecurityLevel( UInt16 security_level );
Int16 ScanGetUpcEanSecurityLevel();

Int16 ScanSetEanZeroExtend( Boolean bEnable );
Int16 ScanGetEanZeroExtend();

Int16 ScanSetHostSerialResponseTimeOut( UInt16 time_out );
Int16 ScanGetHostSerialResponseTimeOut();


/*******************************************************************
 *              Decoder Command Functions...                       *
 *******************************************************************/
// Stu 4/16/98: Took out - this has been renamed to ScanGetDecodedData()
// Int16 ScanCmdDecodeData( MESSAGE *ptr );
Int16 ScanCmdParamDefaults();

Int16 ScanCmdScanEnable();
Int16 ScanCmdScanDisable();

Int16 ScanCmdStartDecode();
Int16 ScanCmdStopDecode();

Int16 ScanCmdLedOn();
Int16 ScanCmdLedOff();

Int16 ScanCmdAimOn();
Int16 ScanCmdAimOff();

Int16 ScanGetAimMode();
Int16 ScanGetScanEnabled();
Int16 ScanGetLedState();

/*******************************************************************
 *              Decoder Hardware Functions...                      * 
 *******************************************************************/
Int16 ScanSetLaserOnTime( UInt16 laser_on_time);
Int16 ScanGetLaserOnTime();

Int16 ScanSetDecodeLedOnTime( UInt16 led_on_time);
Int16 ScanGetDecodeLedOnTime();

Int16 ScanSetAngle( UInt16 scan_angle );
Int16 ScanGetAngle();

Int16 ScanSetAimDuration( UInt16 aim_duration);
Int16 ScanGetAimDuration();

Int16 ScanSetTriggeringModes( UInt16 triggering_mode);
Int16 ScanGetTriggeringModes();

Int16 ScanSetTimeOutBetweenSameSymbol( UInt16 time_out );
Int16 ScanGetTimeOutBetweenSameSymbol();

Int16 ScanSetLinearCodeTypeSecurityLevel( UInt16 security_level );
Int16 ScanGetLinearCodeTypeSecurityLevel();

Int16 ScanSetBidirectionalRedundancy( UInt16 redundancy );
Int16 ScanGetBidirectionalRedundancy();

Int16 ScanSetTransmitCodeIdCharacter( UInt16 code_id );
Int16 ScanGetTransmitCodeIdCharacter();

Int16 ScanSetScanDataTransmissionFormat( UInt16 transmission_format );
Int16 ScanGetScanDataTransmissionFormat();

/*******************************************************************
 *                 Beeper Functions...                             * 
 *******************************************************************/
Int16 ScanCmdBeep( BeepType beep );

Int16 ScanSetBeepAfterGoodDecode( Boolean bEnableBeep );
Int16 ScanGetBeepAfterGoodDecode();

Int16 ScanSetBeepFrequency( FrequencyType type, Int16 beep_freq );
Int16 ScanGetBeepFrequency( FrequencyType type );

Int16 ScanSetBeepDuration( DurationType type, Int16 beep_duration );
Int16 ScanGetBeepDuration( DurationType type );

/*******************************************************************
 *  Trigger Sled Functions										   *
 *******************************************************************/
Int16 ScanCmdTrigSledOn();
Int16 ScanCmdTrigSledOff();
Int16 ScanGetTrigSledMode();

#ifdef __cplusplus
    }
#endif
